<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (Schema::hasColumn('releases', 'lyrics_file')) {
            Schema::table('releases', function (Blueprint $table) {
                $table->dropColumn('lyrics_file');
            });
        }
        Schema::table('releases', function (Blueprint $table) {
            $table->text('lyrics_file')->nullable()->after('lyrics_duration');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('releases', function (Blueprint $table) {
            $table->dropColumn('lyrics_file');
        });
    }
};
